#include <p30fxxxx.h>
#include <outcompare.h>

/* This devices support OutputCompare 5 thru OutputCompare 8 */
#if defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__) || defined(__dsPIC30F6011__) || \
    defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6013__) || \
    defined(__dsPIC30F6014__)

/********************************************************************
* Function Name :  CloseOC8                                         *
* Description   :  This routine disables the Output Compare and its *
*                  interrupt bits.                                  *
* Parameter     :  None                                             *
* Return Value  :  None                                             *
********************************************************************/

void CloseOC8()
{   
    IEC2bits.OC8IE = 0; /* Disable the Interrupt bit in IEC Register */
    OC8CONbits.OCM = 0; /* Turn off Output Compare 8 */
    IFS2bits.OC8IF = 0; /* Disable the Interrupt Flag bit in IFS Register */
}

#endif 
